class CustomPages {
  List<CustomPage>? customPage;

  CustomPages({this.customPage});

  CustomPages.fromJson(Map<String, dynamic> json) {
    if (json['customPage'] != null) {
      customPage = <CustomPage>[];
      json['customPage'].forEach((v) {
        customPage!.add(new CustomPage.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.customPage != null) {
      data['customPage'] = this.customPage!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class CustomPage {
  int? id;
  String? title;
  String? slug;
  int? inShowMenu;
  String? detail;
  int? isActive;
  String? createdAt;
  String? updatedAt;
  String? pageType;

  CustomPage(
      {this.id,
      this.title,
      this.slug,
      this.inShowMenu,
      this.detail,
      this.isActive,
      this.createdAt,
      this.updatedAt,
      this.pageType});

  CustomPage.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    title = json['title'];
    slug = json['slug'];
    inShowMenu = json['in_show_menu'];
    detail = json['detail'];
    isActive = json['is_active'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    pageType = json['page_type'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['title'] = this.title;
    data['slug'] = this.slug;
    data['in_show_menu'] = this.inShowMenu;
    data['detail'] = this.detail;
    data['is_active'] = this.isActive;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['page_type'] = this.pageType;
    return data;
  }
}
